/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.aspects4swing;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.runtime.internal.AroundClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public abstract class Sl4jTrace {
    protected static int callDepth = 0;
    private static String spaces = "  ";

    public static void setIndent(String newSpaces) {
        spaces = newSpaces == null ? "" : newSpaces;
    }

    protected static void logBegin(Logger log, JoinPoint jp) {
        ++callDepth;
        String indent = Sl4jTrace.getIndent();
        log.trace(String.valueOf(indent) + "BEGIN " + jp.getSignature().getName() + "(" + Sl4jTrace.getArgs(jp) + ")");
        Sl4jTrace.logArguments(log, indent, jp);
    }

    protected static void logFunctionEnd(Logger log, JoinPoint jp, Object result) {
        String indent = Sl4jTrace.getIndent();
        log.trace(String.valueOf(indent) + "result=" + result);
        log.trace(String.valueOf(indent) + "END " + jp.getSignature().getName());
        --callDepth;
    }

    protected static void logEnd(Logger log, JoinPoint jp) {
        log.trace(String.valueOf(Sl4jTrace.getIndent()) + "END " + jp.getSignature().getName());
        --callDepth;
    }

    private static String getIndent() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < callDepth) {
            sb.append(spaces);
            ++i;
        }
        return sb.toString();
    }

    private static String getArgs(JoinPoint jp) {
        Class[] types = ((CodeSignature)jp.getSignature()).getParameterTypes();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(types[i].getSimpleName());
            ++i;
        }
        return sb.toString();
    }

    private static void logArguments(Logger log, String indent, JoinPoint jp) {
        Object[] args = jp.getArgs();
        String[] names = ((CodeSignature)jp.getSignature()).getParameterNames();
        int i = 0;
        while (i < args.length) {
            log.trace(String.valueOf(indent) + names[i] + "=" + args[i]);
            ++i;
        }
    }

    @Pointcut(value="", argNames="")
    public abstract /* synthetic */ void ajc$pointcut$$aClass$f32();

    @Pointcut(value="(aClass() && execution(new(..)))", argNames="")
    /* synthetic */ void ajc$pointcut$$aConstructor$f78() {
    }

    @Pointcut(value="(aClass() && (execution(* *(..)) && (!aMethod() && !execution(java.lang.String toString()))))", argNames="")
    /* synthetic */ void ajc$pointcut$$aFunction$1006() {
    }

    @Pointcut(value="(aClass() && execution(void *(..)))", argNames="")
    /* synthetic */ void ajc$pointcut$$aMethod$10aa() {
    }

    @Before(value="aConstructor()", argNames="")
    public void ajc$before$org_fuin_aspects4swing_Sl4jTrace$1$5ca55b9a(JoinPoint.StaticPart thisJoinPointStaticPart, JoinPoint thisJoinPoint) {
        Logger log = LoggerFactory.getLogger((Class)thisJoinPointStaticPart.getSignature().getDeclaringType());
        if (log.isTraceEnabled()) {
            Sl4jTrace.logBegin(log, thisJoinPoint);
        }
    }

    @After(value="aConstructor()", argNames="")
    public void ajc$after$org_fuin_aspects4swing_Sl4jTrace$2$5ca55b9a(JoinPoint.StaticPart thisJoinPointStaticPart, JoinPoint thisJoinPoint) {
        Logger log = LoggerFactory.getLogger((Class)thisJoinPointStaticPart.getSignature().getDeclaringType());
        if (log.isTraceEnabled()) {
            Sl4jTrace.logEnd(log, thisJoinPoint);
        }
    }

    @Before(value="aMethod()", argNames="")
    public void ajc$before$org_fuin_aspects4swing_Sl4jTrace$3$175d9523(JoinPoint.StaticPart thisJoinPointStaticPart, JoinPoint thisJoinPoint) {
        Logger log = LoggerFactory.getLogger((Class)thisJoinPointStaticPart.getSignature().getDeclaringType());
        if (log.isTraceEnabled()) {
            Sl4jTrace.logBegin(log, thisJoinPoint);
        }
    }

    @After(value="aMethod()", argNames="")
    public void ajc$after$org_fuin_aspects4swing_Sl4jTrace$4$175d9523(JoinPoint.StaticPart thisJoinPointStaticPart, JoinPoint thisJoinPoint) {
        Logger log = LoggerFactory.getLogger((Class)thisJoinPointStaticPart.getSignature().getDeclaringType());
        if (log.isTraceEnabled()) {
            Sl4jTrace.logEnd(log, thisJoinPoint);
        }
    }

    @Around(value="(aFunction() && !execution(* aFunction()))", argNames="ajc$aroundClosure")
    public Object ajc$around$org_fuin_aspects4swing_Sl4jTrace$5$17b56ce5(AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart, JoinPoint thisJoinPoint) {
        Logger log = LoggerFactory.getLogger((Class)thisJoinPointStaticPart.getSignature().getDeclaringType());
        if (log.isTraceEnabled()) {
            Sl4jTrace.logBegin(log, thisJoinPoint);
            Object result = ajc$aroundClosure.run(new Object[0]);
            Sl4jTrace.logFunctionEnd(log, thisJoinPoint, result);
            return result;
        }
        return ajc$aroundClosure.run(new Object[0]);
    }
}

