/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.util.List;
import java.util.Map;
import org.fuin.apps4j.base.Controller;
import org.fuin.apps4j.base.Usage;
import org.fuin.apps4j.base.View;
import org.fuin.apps4swing.AbstractControllerQueue;
import org.fuin.apps4swing.AbstractModuleImpl;
import org.fuin.apps4swing.AbstractMvcContext;
import org.fuin.apps4swing.AbstractToControllerDispatcher;
import org.fuin.apps4swing.AbstractToViewDispatcher;
import org.fuin.apps4swing.MvcBundle;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractRefreshableApplicationContext;

public final class SpringMvcContext
extends AbstractMvcContext
implements ApplicationContextAware {
    private ApplicationContext ctx;
    private DefaultListableBeanFactory beanFactory;

    public final void setApplicationContext(ApplicationContext ctx) {
        if (!(ctx instanceof AbstractRefreshableApplicationContext)) {
            throw new IllegalArgumentException(String.valueOf(ApplicationContext.class.getSimpleName()) + " is not of type " + AbstractRefreshableApplicationContext.class.getSimpleName());
        }
        AbstractRefreshableApplicationContext rac = (AbstractRefreshableApplicationContext)ctx;
        ConfigurableListableBeanFactory bf = rac.getBeanFactory();
        if (!(bf instanceof DefaultListableBeanFactory)) {
            throw new IllegalArgumentException("Factory is not a '" + DefaultListableBeanFactory.class.getName() + "' as expected: " + bf.getClass().getName());
        }
        this.ctx = ctx;
        this.beanFactory = (DefaultListableBeanFactory)bf;
    }

    private String firstCharLower(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return "" + Character.toLowerCase(str.charAt(0));
        }
        return String.valueOf(Character.toLowerCase(str.charAt(0))) + str.substring(1);
    }

    @Override
    public final void init() {
        if (this.ctx == null) {
            throw new IllegalStateException("Variable 'ctx' not set!");
        }
        if (this.beanFactory == null) {
            throw new IllegalStateException("Variable 'beanFactory' not set!");
        }
        List<MvcBundle> bundles = this.getBundles();
        for (MvcBundle bundle : bundles) {
            bundle.generateClasses();
            this.registerBean(bundle.getName(), bundle.getViewIntf(), bundle.getToViewDispClass(), Usage.Type.Controller, "ToViewDisp");
            this.registerBean(bundle.getName(), bundle.getCtrlIntf(), bundle.getToCtrlDispClass(), Usage.Type.View, "ToCtrlDisp");
            this.registerBean(bundle.getName(), bundle.getCtrlIntf(), bundle.getCtrlQueueClass(), Usage.Type.ThirdParty, "CtrlQueue");
            if (bundle.getModuleIntf() == null) continue;
            this.registerBean(bundle.getName(), bundle.getModuleIntf(), bundle.getModuleClass(), Usage.Type.ThirdParty, "Module");
        }
        for (MvcBundle bundle : bundles) {
            View viewImpl = (View)this.getImpl(bundle.getViewIntf());
            Controller ctrlImpl = (Controller)this.getImpl(bundle.getCtrlIntf());
            AbstractToViewDispatcher toViewDispatcher = (AbstractToViewDispatcher)this.ctx.getBean(bundle.getToViewDispClass());
            AbstractControllerQueue ctrlQueue = (AbstractControllerQueue)this.ctx.getBean(bundle.getCtrlQueueClass());
            AbstractToControllerDispatcher toCtrlDispatcher = (AbstractToControllerDispatcher)this.ctx.getBean(bundle.getToCtrlDispClass());
            this.connectToViewDispatcher(toViewDispatcher, viewImpl);
            this.connectControllerQueue(ctrlQueue, toViewDispatcher, ctrlImpl, bundle.getExecutorService(), bundle.getQueueCapacity());
            this.connectToCtrlDispatcher(toCtrlDispatcher, ctrlQueue, bundle.getExecutorService());
            if (bundle.getModuleIntf() == null) continue;
            AbstractModuleImpl module = (AbstractModuleImpl)this.ctx.getBean(bundle.getModuleClass());
            this.connectModule(module, ctrlQueue);
        }
    }

    private Object getImpl(Class intf) {
        Map beanMap = this.ctx.getBeansOfType(intf);
        for (String name : beanMap.keySet()) {
            Object bean = beanMap.get(name);
            Usage usage = bean.getClass().getAnnotation(Usage.class);
            if (usage == null || !usage.value().equals((Object)Usage.Type.Intern)) continue;
            return bean;
        }
        throw new IllegalStateException("No implementation of interface '" + intf.getName() + "' found that is annotated with '@Usage(Type.Intern)'!");
    }

    private void registerBean(String name, Class beanIntf, Class beanClass, Usage.Type usageType, String part) {
        if (beanIntf == null) {
            throw new IllegalArgumentException("Argument 'beanIntf' cannot be null [" + name + " / " + part + "]!");
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("Argument 'beanClass' cannot be null [" + name + " / " + part + "]!");
        }
        if (usageType == null) {
            throw new IllegalArgumentException("Argument 'usageType' cannot be null [" + name + " / " + part + "]!");
        }
        GenericBeanDefinition beanDef = new GenericBeanDefinition();
        beanDef.setBeanClass(beanClass);
        beanDef.addQualifier(new AutowireCandidateQualifier(Usage.class, (Object)usageType));
        beanDef.setAutowireMode(0);
        this.beanFactory.registerBeanDefinition(this.firstCharLower(beanClass.getSimpleName()), (BeanDefinition)beanDef);
    }
}

