/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.io.File;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;
import org.fuin.apps4j.base.Apps4JUtils;
import org.fuin.apps4j.base.Controller;
import org.fuin.apps4j.base.ModulImplIntfRef;
import org.fuin.apps4j.base.ModuleImplIntf;
import org.fuin.apps4j.base.View;
import org.fuin.apps4swing.AbstractControllerQueue;
import org.fuin.apps4swing.AbstractModuleImpl;
import org.fuin.apps4swing.AbstractToControllerDispatcher;
import org.fuin.apps4swing.AbstractToViewDispatcher;
import org.fuin.apps4swing.Apps4SwingUtils;
import org.fuin.apps4swing.ControllerQueueFactoryListener;
import org.fuin.apps4swing.ModuleImplFactoryListener;
import org.fuin.apps4swing.ToControllerDispatcherFactoryListener;
import org.fuin.apps4swing.ToViewDispatcherFactoryListener;
import org.fuin.objects4j.validation.NotEmpty;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.factory.ImplementationFactory;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;

public final class MvcBundle<VIEW extends View<CTRL>, CTRL extends Controller<VIEW>, MODULE> {
    @NotEmpty
    private String name;
    @NotEmpty
    private String pkg;
    @NotNull
    private Class<? extends CTRL> ctrlIntf;
    private CTRL ctrlImpl;
    @NotNull
    private Class<? extends VIEW> viewIntf;
    private VIEW viewImpl;
    @NotNull
    private Class<? extends MODULE> moduleIntf;
    @NotNull
    private Class<? extends ModuleImplIntf> moduleImplIntf;
    @NotNull
    private ExecutorService executorService;
    @NotNull
    private int queueCapacity = 4;
    private File srcDir;
    @NotNull
    private Class<? extends AbstractToViewDispatcher<VIEW, CTRL>> toViewDispClass;
    @NotNull
    private Class<? extends AbstractControllerQueue<CTRL, VIEW>> ctrlQueueClass;
    @NotNull
    private Class<? extends AbstractModuleImpl> moduleClass;
    @NotNull
    private Class<? extends AbstractToControllerDispatcher<Controller<VIEW>, VIEW>> toCtrlDispClass;

    public final void setName(String name) {
        this.name = name;
    }

    public final void setPkg(String pkg) {
        this.pkg = pkg;
    }

    public final void setCtrlIntf(Class<? extends CTRL> ctrlIntf) {
        this.ctrlIntf = ctrlIntf;
    }

    public final void setCtrlImpl(CTRL ctrlImpl) {
        this.ctrlImpl = ctrlImpl;
    }

    public final void setViewIntf(Class<? extends VIEW> viewIntf) {
        this.viewIntf = viewIntf;
    }

    public final void setViewImpl(VIEW viewImpl) {
        this.viewImpl = viewImpl;
    }

    public final void setModuleIntf(Class<? extends MODULE> moduleIntf) {
        this.moduleIntf = moduleIntf;
    }

    public final void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public final void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public final void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public final Class<? extends VIEW> getViewIntf() {
        return this.viewIntf;
    }

    public final Class<? extends AbstractToViewDispatcher<VIEW, CTRL>> getToViewDispClass() {
        return this.toViewDispClass;
    }

    public final Class<? extends AbstractControllerQueue<CTRL, VIEW>> getCtrlQueueClass() {
        return this.ctrlQueueClass;
    }

    public final Class<? extends AbstractModuleImpl> getModuleClass() {
        return this.moduleClass;
    }

    public final Class<? extends AbstractToControllerDispatcher<Controller<VIEW>, VIEW>> getToCtrlDispClass() {
        return this.toCtrlDispClass;
    }

    public final Class<? extends CTRL> getCtrlIntf() {
        return this.ctrlIntf;
    }

    public final Class<? extends MODULE> getModuleIntf() {
        return this.moduleIntf;
    }

    public final Class<? extends ModuleImplIntf> getModuleImplIntf() {
        return this.moduleImplIntf;
    }

    private final void writeToFile(SgClass sgClass) {
        if (this.srcDir != null) {
            File dir = new File(this.srcDir, sgClass.getPackageName().replace('.', File.separatorChar));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, String.valueOf(sgClass.getSimpleName()) + ".java");
            Apps4SwingUtils.writeToFile(file, sgClass.toString());
        }
    }

    public final void generateClasses() {
        SgClassPool pool = new SgClassPool();
        ByteCodeGenerator generator = new ByteCodeGenerator();
        ImplementationFactory factory = new ImplementationFactory(pool);
        if (this.executorService == null) {
            this.executorService = Apps4JUtils.createExecutorService();
        }
        if (this.moduleIntf == null) {
            this.moduleImplIntf = null;
        } else {
            ModulImplIntfRef ref = this.moduleIntf.getAnnotation(ModulImplIntfRef.class);
            if (ref == null) {
                throw new IllegalArgumentException("The interface '" + this.moduleIntf.getName() + "' ist not annotated with '" + ModulImplIntfRef.class.getName() + "'!");
            }
            this.moduleImplIntf = ref.value();
            this.generateModuleClass(pool, generator, factory);
        }
        this.generateToViewDispatcherClass(pool, generator, factory);
        this.generateControllerQueueClass(pool, generator, factory);
        this.generateToControllerDispatcherClass(pool, generator, factory);
    }

    private void generateToViewDispatcherClass(SgClassPool pool, ByteCodeGenerator generator, ImplementationFactory factory) {
        SgClass toViewDispSuperClasz = SgClass.create((SgClassPool)pool, AbstractToViewDispatcher.class);
        ToViewDispatcherFactoryListener listener = new ToViewDispatcherFactoryListener(pool, generator);
        SgClass toViewDispClasz = factory.create(this.pkg, String.valueOf(this.name) + "ToViewDispatcher", toViewDispSuperClasz, null, (ImplementationFactoryListener)listener, new Class[]{this.viewIntf});
        this.writeToFile(toViewDispClasz);
        this.toViewDispClass = generator.createClass(toViewDispClasz);
    }

    private void generateControllerQueueClass(SgClassPool pool, ByteCodeGenerator generator, ImplementationFactory factory) {
        ControllerQueueFactoryListener listener = new ControllerQueueFactoryListener(pool, generator);
        SgClass ctrlQueueSuperClass = SgClass.create((SgClassPool)pool, AbstractControllerQueue.class);
        Class[] interfaces = this.moduleIntf == null ? new Class[]{this.ctrlIntf} : new Class[]{this.ctrlIntf, this.moduleImplIntf};
        SgClass ctrlQueueClasz = factory.create(this.pkg, String.valueOf(this.name) + "ControllerQueue", ctrlQueueSuperClass, null, (ImplementationFactoryListener)listener, interfaces);
        this.writeToFile(ctrlQueueClasz);
        this.ctrlQueueClass = generator.createClass(ctrlQueueClasz);
    }

    private void generateModuleClass(SgClassPool pool, ByteCodeGenerator generator, ImplementationFactory factory) {
        SgClass moduleSuperClass = SgClass.create((SgClassPool)pool, AbstractModuleImpl.class);
        SgClass moduleClasz = factory.create(this.pkg, String.valueOf(this.name) + "ModuleImpl", moduleSuperClass, null, (ImplementationFactoryListener)new ModuleImplFactoryListener(pool, this.moduleImplIntf), new Class[]{this.moduleIntf});
        this.writeToFile(moduleClasz);
        this.moduleClass = generator.createClass(moduleClasz);
    }

    private void generateToControllerDispatcherClass(SgClassPool pool, ByteCodeGenerator generator, ImplementationFactory factory) {
        SgClass toCtrlDispParentClasz = SgClass.create((SgClassPool)pool, AbstractToControllerDispatcher.class);
        ToControllerDispatcherFactoryListener listener = new ToControllerDispatcherFactoryListener(pool, generator);
        SgClass toCtrlDispClasz = factory.create(this.pkg, String.valueOf(this.name) + "ToControllerDispatcher", toCtrlDispParentClasz, null, (ImplementationFactoryListener)listener, new Class[]{this.ctrlIntf});
        this.writeToFile(toCtrlDispClasz);
        this.toCtrlDispClass = generator.createClass(toCtrlDispClasz);
    }

    public final String getName() {
        return this.name;
    }

    public final String getPkg() {
        return this.pkg;
    }

    public final CTRL getCtrlImpl() {
        return this.ctrlImpl;
    }

    public final VIEW getViewImpl() {
        return this.viewImpl;
    }

    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    public final int getQueueCapacity() {
        return this.queueCapacity;
    }

    public final File getSrcDir() {
        return this.srcDir;
    }
}

