/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.util.ArrayList;
import java.util.List;
import org.fuin.apps4j.base.ModuleImplIntf;
import org.fuin.apps4j.base.ModuleImplIntfListener;
import org.fuin.apps4j.base.WaitForUserInput;
import org.fuin.apps4swing.AbstractModuleImplIntfListener;
import org.fuin.apps4swing.Apps4SwingUtils;
import org.fuin.apps4swing.ModuleImplIntfListenerFactoryListener;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;
import org.fuin.srcgen4javassist.factory.ImplementationFactory;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;
import org.fuin.utils4j.Utils4J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModuleImplFactoryListener
implements ImplementationFactoryListener {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleImplFactoryListener.class);
    private ImplementationFactory factory;
    private ByteCodeGenerator generator;
    private final ModuleImplIntfListenerFactoryListener listenerFactoryListener;
    private final SgClass moduleImplIntfClass;
    private final SgClass moduleImplIntfListenerClass;
    private final SgClassPool pool;

    public ModuleImplFactoryListener(SgClassPool pool, Class<? extends ModuleImplIntf> moduleImplIntf) {
        Utils4J.checkNotNull((String)"pool", (Object)pool);
        this.pool = pool;
        Utils4J.checkNotNull((String)"moduleImplIntf", moduleImplIntf);
        this.moduleImplIntfClass = SgClass.create((SgClassPool)pool, moduleImplIntf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("moduleImplIntf=" + moduleImplIntf.getName());
        }
        this.factory = new ImplementationFactory(pool, true);
        this.generator = new ByteCodeGenerator();
        this.listenerFactoryListener = new ModuleImplIntfListenerFactoryListener();
        this.moduleImplIntfListenerClass = SgClass.create((SgClassPool)pool, ModuleImplIntfListener.class);
    }

    public final void afterClassCreated(SgClass clasz) {
        SgClass sl4jLoggerClasz = SgClass.create((SgClassPool)this.pool, Logger.class);
        clasz.addField(new SgField(clasz, "private static", sl4jLoggerClasz, "LOG", "org.slf4j.LoggerFactory.getLogger(" + clasz.getName() + ".class)"));
    }

    private boolean isSameArgumentsPlusListener(SgMethod moduleIntfMethod, SgMethod moduleImplIntfMethod) {
        if (moduleIntfMethod.getArguments().size() != moduleImplIntfMethod.getArguments().size() + 1) {
            return false;
        }
        List moduleIntfMethodArgs = moduleIntfMethod.getArguments();
        List moduleImplIntfMethodArgs = moduleImplIntfMethod.getArguments();
        if (!((SgArgument)moduleIntfMethodArgs.get(0)).getType().hasInterface(this.moduleImplIntfListenerClass)) {
            return false;
        }
        int i = 1;
        while (i < moduleIntfMethodArgs.size()) {
            SgArgument m1arg = (SgArgument)moduleIntfMethodArgs.get(i);
            SgArgument m2arg = (SgArgument)moduleImplIntfMethodArgs.get(i - 1);
            if (!m1arg.getType().equals(m2arg.getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private SgClass getModuleImplIntfListener(SgClass moduleImplIntf, SgMethod method) {
        List methods = moduleImplIntf.getMethods();
        int i = 0;
        while (i < methods.size()) {
            SgMethod meth = (SgMethod)methods.get(i);
            if (meth.getName().equals(method.getName()) && meth.getReturnType().equals(SgClass.VOID) && this.isSameArgumentsPlusListener(meth, method)) {
                return ((SgArgument)meth.getArguments().get(0)).getType();
            }
            ++i;
        }
        List interfaces = moduleImplIntf.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.size()) {
            SgClass cl = this.getModuleImplIntfListener((SgClass)interfaces.get(i2), method);
            if (cl != null) {
                return cl;
            }
            ++i2;
        }
        return null;
    }

    private void checkModuleImplIntfListenerNotNull(SgClass listener, SgClass moduleImplIntf, SgMethod method) {
        if (listener == null) {
            StringBuffer expected = new StringBuffer("public void ");
            expected.append(method.getName());
            expected.append("(");
            expected.append(String.valueOf(SgUtils.firstCharUpper((String)method.getName())) + "Listener listener");
            List args = method.getArguments();
            int i = 0;
            while (i < args.size()) {
                SgArgument arg = (SgArgument)args.get(i);
                expected.append(", ");
                expected.append(arg.getType().getName());
                expected.append(" ");
                expected.append(arg.getName());
                ++i;
            }
            expected.append(")");
            throw new IllegalArgumentException("No method '" + expected + "' found in interface '" + moduleImplIntf.getName() + "'!");
        }
    }

    private Class<?> getListenerClass(SgClass moduleImplIntfListener) {
        try {
            return Class.forName(moduleImplIntfListener.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Class getListenerImpl(SgClass modulImplClasz, SgClass moduleImplIntfListener) {
        String name = String.valueOf(modulImplClasz.getSimpleName()) + "_" + moduleImplIntfListener.getSimpleName().replace('$', '_');
        try {
            Class<?> cl = Class.forName(name);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(name) + " already exists");
            }
            return cl;
        }
        catch (ClassNotFoundException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(name) + " does not exists");
            }
            Class<?> intfClass = this.getListenerClass(moduleImplIntfListener);
            SgClass superClass = SgClass.create((SgClassPool)this.pool, AbstractModuleImplIntfListener.class);
            SgClass clasz = this.factory.create(modulImplClasz.getPackageName(), name, superClass, null, (ImplementationFactoryListener)this.listenerFactoryListener, new Class[]{intfClass});
            clasz.addInterface(this.moduleImplIntfListenerClass);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Created ModuleImplIntfListener\n" + clasz);
            }
            Class cl = this.generator.createClass(clasz);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(name) + " was created successfully");
            }
            return cl;
        }
    }

    public final List<String> createBody(SgMethod method, Class<?> ... intf) {
        ArrayList<String> lines = new ArrayList<String>();
        Apps4SwingUtils.addMethodCallLogStmt(this.pool, lines, method);
        if (method.hasAnnotation(WaitForUserInput.class.getName())) {
            this.addSrcWaitingForUserInput(lines, method, this.moduleImplIntfClass);
        } else {
            this.addSrcNotWaitingForUserInput(lines, method, this.moduleImplIntfClass);
        }
        return lines;
    }

    private void addSrcNotWaitingForUserInput(List<String> lines, SgMethod method, SgClass moduleImplIntf) {
        lines.add(String.valueOf(moduleImplIntf.getName()) + " module = (" + moduleImplIntf.getName() + ") getModule();");
        String call = method.getArguments().size() == 0 ? "module." + method.getName() + "()" : "module." + method.getName() + "(" + method.getCommaSeparatedArgumentNames() + ")";
        if (method.getReturnType().equals(SgClass.VOID)) {
            lines.add(String.valueOf(call) + ";");
        } else {
            this.addReturnValue(lines, method, call);
        }
    }

    private void addReturnValue(List<String> lines, SgMethod method, String call) {
        if (method.getReturnType().isPrimitive()) {
            SgClass nonPrimitiveClass = SgClass.getNonPrimitiveClass((SgClassPool)this.pool, (SgClass)method.getReturnType());
            String convMethod = SgClass.getToPrimitiveMethod((SgClass)nonPrimitiveClass);
            lines.add(String.valueOf(method.getReturnType().getName()) + " retVal = ((" + nonPrimitiveClass.getName() + ") " + call + ")." + convMethod + "();");
        } else {
            lines.add(String.valueOf(method.getReturnType().getName()) + " retVal = " + call + ";");
        }
        Apps4SwingUtils.addVarTraceStmt(this.pool, lines, "retVal", method.getReturnType());
        lines.add("return retVal;");
    }

    private void addSrcWaitingForUserInput(List<String> lines, SgMethod method, SgClass moduleImplIntf) {
        SgClass moduleImplIntfListener = this.getModuleImplIntfListener(moduleImplIntf, method);
        if (LOG.isDebugEnabled()) {
            LOG.debug("moduleImplIntfListener=" + moduleImplIntfListener.getName());
        }
        this.checkModuleImplIntfListenerNotNull(moduleImplIntfListener, moduleImplIntf, method);
        Class listenerImplClass = this.getListenerImpl(method.getOwner(), moduleImplIntfListener);
        lines.add(String.valueOf(moduleImplIntf.getName()) + " module = (" + moduleImplIntf.getName() + ") getModule();");
        lines.add(String.valueOf(listenerImplClass.getName()) + " listener = new " + listenerImplClass.getName() + "();");
        if (method.getArguments().size() == 0) {
            lines.add("module." + method.getName() + "(listener);");
        } else {
            lines.add("module." + method.getName() + "(listener, " + method.getCommaSeparatedArgumentNames() + ");");
        }
        lines.add("waitForResults(listener);");
        List exceptions = method.getExceptions();
        int i = 0;
        while (i < exceptions.size()) {
            String getter = "getFailure" + ((SgClass)exceptions.get(i)).getSimpleName() + "()";
            lines.add("if (listener." + getter + "!=null) {");
            lines.add("    throw listener." + getter + ";");
            lines.add("}");
            ++i;
        }
        if (!method.getReturnType().equals(SgClass.VOID)) {
            String call = "listener.getSuccess" + method.getReturnType().getSimpleName() + "()";
            this.addReturnValue(lines, method, call);
        }
    }
}

