/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.fuin.apps4j.base.Target;
import org.fuin.apps4j.menu.DividerMenuItem;
import org.fuin.apps4j.menu.Menu;
import org.fuin.apps4j.menu.MenuItem;
import org.fuin.apps4j.menu.TextMenuItem;

public final class MenuFactory {
    private MenuFactory() {
        throw new UnsupportedOperationException("Cannot create instance of utility class!");
    }

    private static JMenu createJMenu(TextMenuItem item) {
        JMenu jmenu = new JMenu(item.getText());
        MenuFactory.populate(jmenu, item);
        return jmenu;
    }

    private static JMenuItem createJMenuItem(TextMenuItem item) {
        JMenuItem jitem = new JMenuItem(item.getText());
        MenuFactory.populate(jitem, item);
        final Target target = item.getTarget();
        if (target != null) {
            jitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    System.out.println(target.getId());
                }
            });
        }
        return jitem;
    }

    private static void populate(JMenuItem jitem, TextMenuItem item) {
        String accelerator = item.getAccelerator();
        MenuFactory.setAccelerator(jitem, accelerator);
        MenuFactory.setMnemonic(jitem, item);
    }

    private static void setMnemonic(JMenuItem jitem, TextMenuItem item) {
        Integer idx = item.getMnemonicIndex();
        if (idx != null) {
            char ch = item.getText().charAt(idx);
            jitem.setMnemonic((int)ch);
            jitem.setDisplayedMnemonicIndex(idx);
        }
    }

    private static void setAccelerator(JMenuItem jitem, String acc) {
        if (acc != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(acc);
            if (keyStroke == null) {
                throw new IllegalArgumentException("Unknown key stroke '" + acc + "' for item '" + jitem.getText() + "'!");
            }
            jitem.setAccelerator(keyStroke);
        }
    }

    private static void addItems(JMenu jparent, List<MenuItem> items) {
        int i = 0;
        while (i < items.size()) {
            MenuItem item = items.get(i);
            if (item instanceof DividerMenuItem) {
                jparent.add(new JSeparator());
            } else if (item instanceof TextMenuItem) {
                JMenuItem jitem;
                TextMenuItem tmi = (TextMenuItem)item;
                if (tmi.getItems() != null && tmi.getItems().size() > 0) {
                    JMenu jmenu = MenuFactory.createJMenu(tmi);
                    MenuFactory.addItems(jmenu, tmi.getItems());
                    jitem = jmenu;
                } else {
                    jitem = MenuFactory.createJMenuItem(tmi);
                }
                jparent.add(jitem);
            }
            ++i;
        }
    }

    public static JMenuBar createMenuBar(Menu menu) {
        JMenuBar topMenu = new JMenuBar();
        List items = menu.getItems();
        int count = items.size();
        int i = 0;
        while (i < count) {
            MenuItem item = (MenuItem)items.get(i);
            if (item instanceof TextMenuItem) {
                TextMenuItem tmi = (TextMenuItem)item;
                JMenu jmenu = new JMenu(tmi.getText());
                MenuFactory.setMnemonic(jmenu, tmi);
                MenuFactory.addItems(jmenu, tmi.getItems());
                topMenu.add(jmenu);
            }
            ++i;
        }
        return topMenu;
    }

    public static JPopupMenu createPopupMenu(Menu menu) {
        JPopupMenu topMenu = new JPopupMenu();
        List items = menu.getItems();
        int count = items.size();
        int i = 0;
        while (i < count) {
            MenuItem item = (MenuItem)items.get(i);
            if (item instanceof DividerMenuItem) {
                topMenu.addSeparator();
            } else if (item instanceof TextMenuItem) {
                TextMenuItem tmi = (TextMenuItem)item;
                JMenu jmenu = new JMenu(tmi.getText());
                MenuFactory.setMnemonic(jmenu, tmi);
                MenuFactory.addItems(jmenu, tmi.getItems());
                topMenu.add(jmenu);
            }
            ++i;
        }
        return topMenu;
    }
}

