/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fuin.apps4j.base.Controller;
import org.fuin.apps4j.base.View;
import org.fuin.apps4swing.AbstractControllerQueue;
import org.fuin.apps4swing.AbstractModuleImpl;
import org.fuin.apps4swing.AbstractMvcContext;
import org.fuin.apps4swing.AbstractToControllerDispatcher;
import org.fuin.apps4swing.AbstractToViewDispatcher;
import org.fuin.apps4swing.MvcBundle;

public final class ManualMvcContext
extends AbstractMvcContext {
    private final Map<String, AbstractToViewDispatcher<?, ?>> toViewDispatcherMap = new HashMap();
    private final Map<String, AbstractToControllerDispatcher<?, ?>> toCtrlDispatcherMap = new HashMap();
    private final Map<String, AbstractModuleImpl> moduleImplMap = new HashMap<String, AbstractModuleImpl>();

    @Override
    public final void init() {
        List<MvcBundle> bundles = this.getBundles();
        for (MvcBundle bundle : bundles) {
            bundle.generateClasses();
            AbstractToViewDispatcher toViewDispatcher = this.createToViewDisp(bundle);
            this.toViewDispatcherMap.put(bundle.getName(), toViewDispatcher);
            AbstractControllerQueue ctrlQueue = this.createCtrlQueue(bundle);
            AbstractToControllerDispatcher toCtrlDispatcher = this.createToCtrlDisp(bundle, ctrlQueue);
            this.toCtrlDispatcherMap.put(bundle.getName(), toCtrlDispatcher);
            this.connectToViewDispatcher(toViewDispatcher, (View)bundle.getViewImpl());
            this.connectControllerQueue(ctrlQueue, toViewDispatcher, (Controller)bundle.getCtrlImpl(), bundle.getExecutorService(), bundle.getQueueCapacity());
            this.connectToCtrlDispatcher(toCtrlDispatcher, ctrlQueue, bundle.getExecutorService());
            if (bundle.getModuleIntf() == null) continue;
            AbstractModuleImpl module = this.createModule(bundle, ctrlQueue);
            this.moduleImplMap.put(bundle.getName(), module);
            this.connectModule(module, ctrlQueue);
        }
    }

    public final AbstractToViewDispatcher getToViewDispatcher(MvcBundle bundle) {
        return this.toViewDispatcherMap.get(bundle.getName());
    }

    public final AbstractToControllerDispatcher getToControllerDispatcher(MvcBundle bundle) {
        return this.toCtrlDispatcherMap.get(bundle.getName());
    }

    public final AbstractModuleImpl getModuleImpl(MvcBundle bundle) {
        return this.moduleImplMap.get(bundle.getName());
    }

    private AbstractControllerQueue createCtrlQueue(MvcBundle bundle) {
        AbstractControllerQueue ctrlQueue = this.createInstance(bundle.getCtrlQueueClass());
        return ctrlQueue;
    }

    private final AbstractModuleImpl createModule(MvcBundle bundle, AbstractControllerQueue ctrlQueue) {
        AbstractModuleImpl moduleImpl = this.createInstance(bundle.getModuleClass());
        moduleImpl.setModule(ctrlQueue);
        return moduleImpl;
    }

    private final AbstractToControllerDispatcher createToCtrlDisp(MvcBundle bundle, AbstractControllerQueue ctrlQueue) {
        AbstractToControllerDispatcher disp = this.createInstance(bundle.getToCtrlDispClass());
        disp.setExecutorService(bundle.getExecutorService());
        disp.setController(ctrlQueue);
        return disp;
    }

    private final AbstractToViewDispatcher createToViewDisp(MvcBundle bundle) {
        AbstractToViewDispatcher toViewDisp = this.createInstance(bundle.getToViewDispClass());
        toViewDisp.setView(bundle.getViewImpl());
        return toViewDisp;
    }

    private <T> T createInstance(Class<? extends T> clasz) {
        try {
            return clasz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instanciating class!", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error accessing class!", e);
        }
    }
}

