/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.divxdede.swing.busy.JBusyComponent;
import org.fuin.apps4j.base.ModuleImplIntf;
import org.fuin.apps4j.base.WindowManager;
import org.fuin.apps4swing.DefaultButtonCapable;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JFrameWindowManager
implements WindowManager {
    private static final Logger LOG = LoggerFactory.getLogger(JFrameWindowManager.class);
    private Map<String, JFrame> frames = new HashMap<String, JFrame>();

    public final void open(final ModuleImplIntf module, final String title) {
        LOG.debug("open(ModuleImplIntf, String)");
        if (SwingUtilities.isEventDispatchThread()) {
            this.openIntern(module, title);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JFrameWindowManager.this.openIntern(module, title);
                    }
                });
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void openIntern(final ModuleImplIntf module, String title) {
        LOG.debug("openIntern(ModuleImplIntf, String)");
        JFrame frame = this.frames.get(module.getName());
        if (frame != null) {
            throw new IllegalStateException("Method 'open(ModuleImplIntf)' called twice!");
        }
        if (module.getModuleUI() instanceof JFrame) {
            frame = (JFrame)module.getModuleUI();
            frame.setSize(frame.getPreferredSize());
        } else {
            frame = new JFrame(title);
            Container container = (Container)module.getModuleUI();
            frame.setContentPane(container);
            frame.setSize(container.getPreferredSize());
            DefaultButtonCapable dbc = this.getDefaultButtonCapable(container);
            if (dbc != null) {
                frame.getRootPane().setDefaultButton(dbc.getDefaultButton());
            }
        }
        frame.setDefaultCloseOperation(1);
        new ScreenCenterPositioner().position(frame);
        Insets insets = frame.getInsets();
        frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                module.cancel();
            }
        });
        frame.setResizable(true);
        frame.setVisible(true);
        this.frames.put(module.getName(), frame);
    }

    public final void close(final ModuleImplIntf module) {
        LOG.debug("close(ModuleImplIntf)");
        if (SwingUtilities.isEventDispatchThread()) {
            this.closeIntern(module);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JFrameWindowManager.this.closeIntern(module);
                    }
                });
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void closeIntern(ModuleImplIntf module) {
        LOG.debug("closeIntern(ModuleImplIntf)");
        JFrame frame = this.frames.get(module.getName());
        if (frame == null) {
            throw new IllegalStateException("Method 'close(ModuleImplIntf)' called twice!");
        }
        frame.setContentPane(new JPanel());
        frame.setVisible(false);
        this.frames.remove(module.getName());
    }

    private DefaultButtonCapable getDefaultButtonCapable(Container container) {
        JComponent comp;
        if (container instanceof DefaultButtonCapable) {
            return (DefaultButtonCapable)((Object)container);
        }
        if (container instanceof JBusyComponent && (comp = ((JBusyComponent)container).getView()) instanceof DefaultButtonCapable) {
            return (DefaultButtonCapable)((Object)comp);
        }
        return null;
    }
}

