/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.awt.Component;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import org.fuin.apps4j.base.View;
import org.fuin.utils4swing.common.Utils4Swing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ControllerTaskExecutor<CONTROLLER>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerTaskExecutor.class);
    private volatile boolean canceled = false;
    private ArrayBlockingQueue<Runnable> events;
    private ExecutorService executor;
    private View<CONTROLLER> view;

    public final boolean isCanceled() {
        return this.canceled;
    }

    public final void cancel() {
        this.canceled = true;
    }

    public final synchronized void execute(Runnable event) {
        LOG.debug("execute(Runnable)");
        if (this.events.isEmpty()) {
            this.events.add(event);
            this.executor.execute(this);
        } else {
            this.events.add(event);
        }
    }

    private boolean visible(View<?> view) {
        return Utils4Swing.findRootPaneContainer((Component)((Component)view.getViewUI())) != null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        LOG.debug("run()");
        LOG.debug("block() - View visible = " + this.visible(this.view));
        this.view.block();
        try {
            block8: {
                block7: {
                    if (!true) break block7;
                    if (this.canceled) return;
                    if (this.executor.isShutdown()) return;
                    if (this.events.isEmpty()) break block8;
                }
                do {
                    try {
                        this.events.take().run();
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                    if (this.canceled) return;
                    if (this.executor.isShutdown()) return;
                } while (!this.events.isEmpty());
            }
            return;
        }
        finally {
            LOG.debug("unblock() - View visible = " + this.visible(this.view));
            this.view.unblock();
        }
    }

    public final void setEvents(ArrayBlockingQueue<Runnable> events) {
        this.events = events;
    }

    public final void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    public final void setView(View<CONTROLLER> view) {
        this.view = view;
    }
}

