/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import org.fuin.apps4j.base.Controller;
import org.fuin.apps4j.base.View;
import org.fuin.apps4swing.AbstractControllerQueue;
import org.fuin.apps4swing.AbstractModuleImpl;
import org.fuin.apps4swing.AbstractToControllerDispatcher;
import org.fuin.apps4swing.AbstractToViewDispatcher;
import org.fuin.apps4swing.ControllerTaskExecutor;
import org.fuin.apps4swing.MvcBundle;

public abstract class AbstractMvcContext {
    private List<MvcBundle> bundles;

    public final void setBundles(MvcBundle ... bundle) {
        this.bundles = Arrays.asList(bundle);
    }

    public final void setBundles(List<MvcBundle> bundles) {
        this.bundles = bundles;
    }

    public final List<MvcBundle> getBundles() {
        return Collections.unmodifiableList(this.bundles);
    }

    protected final void connectToViewDispatcher(AbstractToViewDispatcher toViewDispatcher, View viewImpl) {
        if (toViewDispatcher == null) {
            throw new IllegalArgumentException("Argument 'toViewDispatcher' cannot be null!");
        }
        if (viewImpl == null) {
            throw new IllegalArgumentException("Argument 'viewImpl' cannot be null!");
        }
        toViewDispatcher.setView(viewImpl);
    }

    protected final void connectControllerQueue(AbstractControllerQueue ctrlQueue, AbstractToViewDispatcher toViewDispatcher, Controller ctrlImpl, ExecutorService executorService, int queueCapacity) {
        if (ctrlQueue == null) {
            throw new IllegalArgumentException("Argument 'ctrlQueue' cannot be null!");
        }
        if (toViewDispatcher == null) {
            throw new IllegalArgumentException("Argument 'toViewDispatcher' cannot be null!");
        }
        if (ctrlImpl == null) {
            throw new IllegalArgumentException("Argument 'ctrlImpl' cannot be null!");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("Argument 'executorService' cannot be null!");
        }
        ControllerTaskExecutor ctrlTaskExecutor = new ControllerTaskExecutor();
        ctrlTaskExecutor.setEvents(new ArrayBlockingQueue<Runnable>(queueCapacity));
        ctrlTaskExecutor.setExecutorService(executorService);
        ctrlTaskExecutor.setView(toViewDispatcher);
        ctrlQueue.setController(ctrlImpl);
        ctrlQueue.setControllerTaskExecutor(ctrlTaskExecutor);
    }

    protected final void connectToCtrlDispatcher(AbstractToControllerDispatcher toCtrlDispatcher, AbstractControllerQueue ctrlQueue, ExecutorService executorService) {
        if (toCtrlDispatcher == null) {
            throw new IllegalArgumentException("Argument 'toCtrlDispatcher' cannot be null!");
        }
        if (ctrlQueue == null) {
            throw new IllegalArgumentException("Argument 'ctrlQueue' cannot be null!");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("Argument 'executorService' cannot be null!");
        }
        toCtrlDispatcher.setController(ctrlQueue);
        toCtrlDispatcher.setExecutorService(executorService);
    }

    protected final void connectModule(AbstractModuleImpl module, AbstractControllerQueue ctrlQueue) {
        module.setModule(ctrlQueue);
    }

    public abstract void init();
}

