/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fuin.apps4swing.EDTGetter;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;
import org.fuin.srcgen4javassist.SgVariable;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;
import org.fuin.srcgen4javassist.factory.VarListImplementationFactory;
import org.fuin.utils4j.ToDebugStringCapable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    private Utils() {
        throw new UnsupportedOperationException("Creating an instance of a utility class is not allowed!");
    }

    public static void addPrivateStaticLogger(SgClassPool pool, SgClass clasz) {
        SgClass sl4jLoggerClasz = SgClass.create((SgClassPool)pool, Logger.class);
        clasz.addField(new SgField(clasz, "private static", sl4jLoggerClasz, "LOG", LoggerFactory.class.getName() + ".getLogger(" + clasz.getName() + ".class)"));
    }

    public static void addVarTraceStmt(SgClassPool pool, List<String> lines, String varName, SgClass varType) {
        if (varType.isPrimitive() || varType.isBaseType()) {
            lines.add("LOG.trace(\"" + varName + "=\" + " + varName + ");");
        } else if (varType.hasInterface(SgClass.create((SgClassPool)pool, ToDebugStringCapable.class))) {
            lines.add("LOG.trace(\"" + varName + "=\" + ((" + ToDebugStringCapable.class.getName() + ") " + varName + ")" + ".toDebugString());");
        } else {
            lines.add("LOG.trace(\"" + varName + "=\" + " + varName + ");");
        }
    }

    public static void addMethodCallLogStmt(SgClassPool pool, List<String> lines, SgMethod method) {
        lines.add("if (LOG.isDebugEnabled()) {");
        lines.add("    LOG.debug(\"" + method.getTypeSignature() + "\");");
        lines.add("}");
        List args = method.getArguments();
        if (args.size() > 0) {
            lines.add("if (LOG.isTraceEnabled()) {");
            for (int i = 0; i < args.size(); ++i) {
                SgArgument arg = (SgArgument)args.get(i);
                Utils.addVarTraceStmt(pool, lines, arg.getName(), arg.getType());
            }
            lines.add("}");
        }
    }

    public static SgClass createRunnableClass(SgClassPool pool, ByteCodeGenerator generator, VarListImplementationFactory varListFactory, final SgVariable var, final SgMethod method) {
        ArrayList<SgVariable> runnableArgs = new ArrayList<SgVariable>();
        runnableArgs.add(var);
        runnableArgs.addAll(method.getArguments());
        String implPackage = method.getOwner().getPackageName();
        String implName = "Runnable" + SgUtils.firstCharUpper((String)method.getName());
        SgClass runnableClass = varListFactory.create(implPackage, implName, null, method.getOwner(), runnableArgs, new ImplementationFactoryListener(){

            public void afterClassCreated(SgClass clasz) {
            }

            public List<String> createBody(SgMethod runMethod, Class<?> ... intf) {
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(var.getName() + "." + method.getCallSignature() + ";");
                return lines;
            }
        }, new Class[]{Runnable.class});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created Runnable\n" + runnableClass);
        }
        try {
            generator.createClass(runnableClass);
        }
        catch (Throwable throwable) {
            String msg = "Error creating Runnable";
            LOG.error("Error creating Runnable:\n" + runnableClass);
            throw new RuntimeException("Error creating Runnable", throwable);
        }
        return runnableClass;
    }

    public static SgClass createEDTGetterClass(SgClassPool pool, ByteCodeGenerator generator, VarListImplementationFactory varListFactory, final SgVariable var, final SgMethod method) {
        ArrayList<SgVariable> getterArgs = new ArrayList<SgVariable>();
        getterArgs.add(var);
        getterArgs.addAll(method.getArguments());
        String implPackage = method.getOwner().getPackageName();
        String implName = "EDTGetter" + SgUtils.firstCharUpper((String)method.getName());
        SgClass getterClass = varListFactory.create(implPackage, implName, null, method.getOwner(), getterArgs, new ImplementationFactoryListener(){

            public void afterClassCreated(SgClass clasz) {
            }

            public List<String> createBody(SgMethod runMethod, Class<?> ... intf) {
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("return " + var.getName() + "." + method.getCallSignature() + ";");
                return lines;
            }
        }, new Class[]{EDTGetter.class});
        generator.createClass(getterClass);
        return getterClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String text) {
        try {
            FileWriter writer = new FileWriter(file);
            try {
                writer.write(text);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

