/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.util.ArrayList;
import java.util.List;
import org.fuin.apps4j.ModuleImplIntf;
import org.fuin.apps4j.ModuleImplIntfListener;
import org.fuin.apps4j.WaitForUserInput;
import org.fuin.apps4swing.AbstractModuleImplIntfListener;
import org.fuin.apps4swing.ModuleImplIntfListenerFactoryListener;
import org.fuin.apps4swing.Utils;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;
import org.fuin.srcgen4javassist.factory.ImplementationFactory;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;
import org.fuin.utils4j.Utils4J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleImplFactoryListener
implements ImplementationFactoryListener {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleImplFactoryListener.class);
    private ImplementationFactory factory;
    private ByteCodeGenerator generator;
    private final ModuleImplIntfListenerFactoryListener listenerFactoryListener;
    private final SgClass moduleImplIntfClass;
    private final SgClass moduleImplIntfListenerClass;
    private final SgClassPool pool;

    public ModuleImplFactoryListener(SgClassPool pool, Class<? extends ModuleImplIntf> moduleImplIntf) {
        Utils4J.checkNotNull((String)"pool", (Object)pool);
        this.pool = pool;
        Utils4J.checkNotNull((String)"moduleImplIntf", moduleImplIntf);
        this.moduleImplIntfClass = SgClass.create((SgClassPool)pool, moduleImplIntf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("moduleImplIntf=" + moduleImplIntf.getName());
        }
        this.factory = new ImplementationFactory(pool, true);
        this.generator = new ByteCodeGenerator();
        this.listenerFactoryListener = new ModuleImplIntfListenerFactoryListener();
        this.moduleImplIntfListenerClass = SgClass.create((SgClassPool)pool, ModuleImplIntfListener.class);
    }

    public final void afterClassCreated(SgClass clasz) {
        SgClass sl4jLoggerClasz = SgClass.create((SgClassPool)this.pool, Logger.class);
        clasz.addField(new SgField(clasz, "private static", sl4jLoggerClasz, "LOG", "org.slf4j.LoggerFactory.getLogger(" + clasz.getName() + ".class)"));
    }

    private boolean isSameArgumentsPlusListener(SgMethod moduleIntfMethod, SgMethod moduleImplIntfMethod) {
        if (moduleIntfMethod.getArguments().size() != moduleImplIntfMethod.getArguments().size() + 1) {
            return false;
        }
        List moduleIntfMethodArgs = moduleIntfMethod.getArguments();
        List moduleImplIntfMethodArgs = moduleImplIntfMethod.getArguments();
        if (!((SgArgument)moduleIntfMethodArgs.get(0)).getType().hasInterface(this.moduleImplIntfListenerClass)) {
            return false;
        }
        for (int i = 1; i < moduleIntfMethodArgs.size(); ++i) {
            SgArgument m1arg = (SgArgument)moduleIntfMethodArgs.get(i);
            SgArgument m2arg = (SgArgument)moduleImplIntfMethodArgs.get(i - 1);
            if (m1arg.getType().equals(m2arg.getType())) continue;
            return false;
        }
        return true;
    }

    private SgClass getModuleImplIntfListener(SgClass moduleImplIntf, SgMethod method) {
        List methods = moduleImplIntf.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            SgMethod meth = (SgMethod)methods.get(i);
            if (!meth.getName().equals(method.getName()) || !meth.getReturnType().equals(SgClass.VOID) || !this.isSameArgumentsPlusListener(meth, method)) continue;
            return ((SgArgument)meth.getArguments().get(0)).getType();
        }
        List interfaces = moduleImplIntf.getInterfaces();
        for (int i = 0; i < interfaces.size(); ++i) {
            SgClass cl = this.getModuleImplIntfListener((SgClass)interfaces.get(i), method);
            if (cl == null) continue;
            return cl;
        }
        return null;
    }

    private void checkModuleImplIntfListenerNotNull(SgClass listener, SgClass moduleImplIntf, SgMethod method) {
        if (listener == null) {
            StringBuffer expected = new StringBuffer("public void ");
            expected.append(method.getName());
            expected.append("(");
            expected.append(SgUtils.firstCharUpper((String)method.getName()) + "Listener listener");
            List args = method.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                SgArgument arg = (SgArgument)args.get(i);
                expected.append(", ");
                expected.append(arg.getType().getName());
                expected.append(" ");
                expected.append(arg.getName());
            }
            expected.append(")");
            throw new IllegalArgumentException("No method '" + expected + "' found in interface '" + moduleImplIntf.getName() + "'!");
        }
    }

    private Class<?> getListenerClass(SgClass moduleImplIntfListener) {
        try {
            return Class.forName(moduleImplIntfListener.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Class getListenerImpl(SgClass modulImplClasz, SgClass moduleImplIntfListener) {
        String name = modulImplClasz.getSimpleName() + "_" + moduleImplIntfListener.getSimpleName().replace('$', '_');
        try {
            Class<?> cl = Class.forName(name);
            if (LOG.isDebugEnabled()) {
                LOG.debug(name + " already exists");
            }
            return cl;
        }
        catch (ClassNotFoundException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(name + " does not exists");
            }
            Class<?> intfClass = this.getListenerClass(moduleImplIntfListener);
            SgClass superClass = SgClass.create((SgClassPool)this.pool, AbstractModuleImplIntfListener.class);
            SgClass clasz = this.factory.create(modulImplClasz.getPackageName(), name, superClass, null, (ImplementationFactoryListener)this.listenerFactoryListener, new Class[]{intfClass});
            clasz.addInterface(this.moduleImplIntfListenerClass);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Created ModuleImplIntfListener\n" + clasz);
            }
            Class cl = this.generator.createClass(clasz);
            if (LOG.isDebugEnabled()) {
                LOG.debug(name + " was created successfully");
            }
            return cl;
        }
    }

    public final List<String> createBody(SgMethod method, Class<?> ... intf) {
        ArrayList<String> lines = new ArrayList<String>();
        Utils.addMethodCallLogStmt(this.pool, lines, method);
        if (method.hasAnnotation(WaitForUserInput.class.getName())) {
            this.addSrcWaitingForUserInput(lines, method, this.moduleImplIntfClass);
        } else {
            this.addSrcNotWaitingForUserInput(lines, method, this.moduleImplIntfClass);
        }
        return lines;
    }

    private void addSrcNotWaitingForUserInput(List<String> lines, SgMethod method, SgClass moduleImplIntf) {
        lines.add(moduleImplIntf.getName() + " module = (" + moduleImplIntf.getName() + ") getModule();");
        String call = method.getArguments().size() == 0 ? "module." + method.getName() + "()" : "module." + method.getName() + "(" + method.getCommaSeparatedArgumentNames() + ")";
        if (method.getReturnType().equals(SgClass.VOID)) {
            lines.add(call + ";");
        } else {
            this.addReturnValue(lines, method, call);
        }
    }

    private void addReturnValue(List<String> lines, SgMethod method, String call) {
        if (method.getReturnType().isPrimitive()) {
            SgClass nonPrimitiveClass = SgClass.getNonPrimitiveClass((SgClassPool)this.pool, (SgClass)method.getReturnType());
            String convMethod = SgClass.getToPrimitiveMethod((SgClass)nonPrimitiveClass);
            lines.add(method.getReturnType().getName() + " retVal = ((" + nonPrimitiveClass.getName() + ") " + call + ")." + convMethod + "();");
        } else {
            lines.add(method.getReturnType().getName() + " retVal = " + call + ";");
        }
        Utils.addVarTraceStmt(this.pool, lines, "retVal", method.getReturnType());
        lines.add("return retVal;");
    }

    private void addSrcWaitingForUserInput(List<String> lines, SgMethod method, SgClass moduleImplIntf) {
        SgClass moduleImplIntfListener = this.getModuleImplIntfListener(moduleImplIntf, method);
        if (LOG.isDebugEnabled()) {
            LOG.debug("moduleImplIntfListener=" + moduleImplIntfListener.getName());
        }
        this.checkModuleImplIntfListenerNotNull(moduleImplIntfListener, moduleImplIntf, method);
        Class listenerImplClass = this.getListenerImpl(method.getOwner(), moduleImplIntfListener);
        lines.add(moduleImplIntf.getName() + " module = (" + moduleImplIntf.getName() + ") getModule();");
        lines.add(listenerImplClass.getName() + " listener = new " + listenerImplClass.getName() + "();");
        if (method.getArguments().size() == 0) {
            lines.add("module." + method.getName() + "(listener);");
        } else {
            lines.add("module." + method.getName() + "(listener, " + method.getCommaSeparatedArgumentNames() + ");");
        }
        lines.add("waitForResults(listener);");
        List exceptions = method.getExceptions();
        for (int i = 0; i < exceptions.size(); ++i) {
            String getter = "getFailure" + ((SgClass)exceptions.get(i)).getSimpleName() + "()";
            lines.add("if (listener." + getter + "!=null) {");
            lines.add("    throw listener." + getter + ";");
            lines.add("}");
        }
        if (!method.getReturnType().equals(SgClass.VOID)) {
            String call = "listener.getSuccess" + method.getReturnType().getSimpleName() + "()";
            this.addReturnValue(lines, method, call);
        }
    }
}

