/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.fuin.apps4j.Module;
import org.fuin.utils4j.Utils4J;

public final class ModuleFrame {
    private final JFrame frame;

    public ModuleFrame(final Module module) {
        Utils4J.checkNotNull((String)"module", (Object)module);
        Object ui = module.getModuleUI();
        if (ui == null) {
            throw new IllegalArgumentException("The module UI is null!");
        }
        if (!(ui instanceof Container)) {
            throw new IllegalArgumentException("The module UI is of type '" + ui.getClass() + "' and not as expected of type '" + Container.class.getName() + "'!");
        }
        Container cont = (Container)ui;
        this.frame = new JFrame(module.getModuleTitle());
        this.frame.setContentPane(cont);
        this.frame.setDefaultCloseOperation(1);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                module.cancel();
            }
        });
        this.frame.setSize(cont.getPreferredSize());
    }

    public final void show() {
        Insets insets = this.frame.getInsets();
        this.frame.setSize(this.frame.getWidth() + insets.left + insets.right, this.frame.getHeight() + insets.top + insets.bottom);
        this.frame.setVisible(true);
    }
}

