/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.ExecutorService;
import javax.swing.JFrame;
import org.fuin.apps4j.Controller;
import org.fuin.apps4j.Module;
import org.fuin.apps4j.ModuleImplIntf;
import org.fuin.apps4j.View;
import org.fuin.apps4j.WindowManager;
import org.fuin.apps4swing.AbstractControllerQueue;
import org.fuin.apps4swing.AbstractControllerViewConnector;
import org.fuin.apps4swing.AbstractModuleImpl;
import org.fuin.apps4swing.ControllerQueueFactoryListener;
import org.fuin.apps4swing.ModuleImplFactoryListener;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.common.FramePositioner;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleControllerViewConnector<MODULE extends Module, CTRL extends Controller<VIEW>, VIEW extends View<CTRL>>
extends AbstractControllerViewConnector<CTRL, VIEW> {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleControllerViewConnector.class);
    private final String modulePkg;
    private MODULE module;

    public ModuleControllerViewConnector(String name, String ctrlPkg, Class<?> ctrlIntf, CTRL ctrlImpl, String viewPkg, Class<?> viewIntf, VIEW viewImpl, String modulePkg, Class<?> moduleIntf, ExecutorService executorService, int queueCapacity) {
        super(name, ctrlPkg, ctrlIntf, ctrlImpl, viewPkg, viewIntf, viewImpl, moduleIntf, executorService, queueCapacity);
        Utils4J.checkNotNull((String)"modulePkg", (Object)modulePkg);
        this.modulePkg = modulePkg;
        Utils4J.checkNotNull((String)"moduleIntf", moduleIntf);
    }

    @Override
    protected final SgClass createControllerQueueClass() {
        ControllerQueueFactoryListener listener = new ControllerQueueFactoryListener(this.getPool(), this.getGenerator());
        SgClass parentClass = SgClass.create((SgClassPool)this.getPool(), AbstractControllerQueue.class);
        return this.getFactory().create(this.getCtrlPkg(), this.getName() + "ControllerQueue", parentClass, null, (ImplementationFactoryListener)listener, new Class[]{this.getCtrlIntf(), this.getModuleImplIntf()});
    }

    private MODULE createModule() {
        SgClass superClass = SgClass.create((SgClassPool)this.getPool(), AbstractModuleImpl.class);
        SgClass clasz = this.getFactory().create(this.modulePkg, this.getName() + "ModuleImpl", superClass, null, (ImplementationFactoryListener)new ModuleImplFactoryListener(this.getPool(), this.getModuleImplIntf()), new Class[]{this.getModuleIntf()});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created ModuleImpl\n" + clasz);
        }
        Module module = (Module)this.getGenerator().createInstance(clasz);
        WindowManager windowManager = ModuleControllerViewConnector.createWindowManager(module);
        ((AbstractModuleImpl)module).setModule((ModuleImplIntf)this.getControllerQueue());
        module.setWindowManager(windowManager);
        return (MODULE)module;
    }

    private static WindowManager createWindowManager(final Module module) {
        return new WindowManager(){
            private JFrame frame;

            public void open() {
                if (this.frame != null) {
                    throw new IllegalStateException("Method 'open()' called twice!");
                }
                Container container = (Container)module.getModuleUI();
                this.frame = Utils4Swing.createShowAndPosition((String)module.getModuleTitle(), (Container)container, (boolean)false, (FramePositioner)new ScreenCenterPositioner());
                this.frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        module.cancel();
                    }
                });
            }

            public void close() {
                if (this.frame == null) {
                    throw new IllegalStateException("Method 'close()' called twice!");
                }
                this.frame.setVisible(false);
                this.frame = null;
            }
        };
    }

    public final MODULE getModule() {
        if (this.module == null) {
            this.module = this.createModule();
        }
        return this.module;
    }
}

