/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import org.fuin.apps4j.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControllerTaskExecutor<CONTROLLER>
implements Runnable {
    private volatile boolean canceled = false;
    private ArrayBlockingQueue<Runnable> events;
    private ExecutorService executor;
    private View<CONTROLLER> view;

    public final boolean isCanceled() {
        return this.canceled;
    }

    public final void cancel() {
        this.canceled = true;
    }

    public final synchronized void execute(Runnable event) {
        if (this.events.isEmpty()) {
            this.events.add(event);
            this.executor.execute(this);
        } else {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.view.block();
        try {
            while (!(this.canceled || this.executor.isShutdown() || this.events.isEmpty())) {
                try {
                    this.events.take().run();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            this.view.unblock();
        }
    }

    public final void setEvents(ArrayBlockingQueue<Runnable> events) {
        this.events = events;
    }

    public final void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    public final void setView(View<CONTROLLER> view) {
        this.view = view;
    }
}

