/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fuin.apps4swing.Utils;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgVariable;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;
import org.fuin.srcgen4javassist.factory.VarListImplementationFactory;
import org.fuin.utils4j.Utils4J;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControllerQueueFactoryListener
implements ImplementationFactoryListener {
    private final SgClassPool pool;
    private final ByteCodeGenerator generator;
    private final VarListImplementationFactory varListFactory;

    public ControllerQueueFactoryListener(SgClassPool pool, ByteCodeGenerator generator) {
        Utils4J.checkNotNull((String)"pool", (Object)pool);
        this.pool = pool;
        Utils4J.checkNotNull((String)"generator", (Object)generator);
        this.generator = generator;
        this.varListFactory = new VarListImplementationFactory(pool);
    }

    public final void afterClassCreated(SgClass clasz) {
        SgClass sl4jLoggerClasz = SgClass.create((SgClassPool)this.pool, Logger.class);
        clasz.addField(new SgField(clasz, "private static", sl4jLoggerClasz, "LOG", "org.slf4j.LoggerFactory.getLogger(" + clasz.getName() + ".class)"));
    }

    public final List<String> createBody(SgMethod method, Class<?> ... intf) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("if (LOG.isDebugEnabled()) {");
        lines.add("    LOG.debug(\"" + method.getTypeSignature() + "\");");
        lines.add("}");
        List args = method.getArguments();
        if (args.size() > 0) {
            lines.add("if (LOG.isTraceEnabled()) {");
            for (int i = 0; i < args.size(); ++i) {
                SgArgument arg = (SgArgument)args.get(i);
                Utils.addVarTraceStmt(this.pool, lines, arg.getName(), arg.getType());
            }
            lines.add("}");
        }
        SgClass callableClass = this.createCallableClass(intf[0], method);
        lines.add(intf[0].getName() + " ctrl = ((" + intf[0].getName() + ") getController());");
        if (method.getArguments().size() == 0) {
            lines.add(Callable.class.getName() + " callable = new " + callableClass.getSourceName() + "(ctrl);");
        } else {
            lines.add(Callable.class.getName() + " callable = new " + callableClass.getSourceName() + "(ctrl, " + method.getCommaSeparatedArgumentNames() + ");");
        }
        if (method.getReturnType().equals(SgClass.VOID)) {
            lines.add("execute(callable);");
        } else {
            lines.add("Object retVal = execute(callable);");
            Utils.addVarTraceStmt(this.pool, lines, "retVal", method.getReturnType());
            if (method.getReturnType().isPrimitive()) {
                SgClass nonPrimitiveClass = SgClass.getNonPrimitiveClass((SgClassPool)this.pool, (SgClass)method.getReturnType());
                String convMethod = SgClass.getToPrimitiveMethod((SgClass)nonPrimitiveClass);
                lines.add("return ((" + nonPrimitiveClass.getName() + ") retVal)." + convMethod + "();");
            } else {
                lines.add("return (" + method.getReturnType().getName() + ") retVal;");
            }
        }
        return lines;
    }

    private SgClass createCallableClass(Class<?> intf, final SgMethod method) {
        ArrayList<1> callableArgs = new ArrayList<1>();
        callableArgs.add(new SgVariable("", SgClass.create((SgClassPool)this.pool, intf), "ctrl"){});
        callableArgs.addAll(method.getArguments());
        String implPackage = method.getOwner().getPackageName();
        String implName = "Callable" + method.getUnderscoredNameAndTypes();
        SgClass callableClass = this.varListFactory.create(implPackage, implName, null, method.getOwner(), callableArgs, new ImplementationFactoryListener(){

            public void afterClassCreated(SgClass clasz) {
            }

            public List<String> createBody(SgMethod runMethod, Class<?> ... intf) {
                ArrayList<String> lines = new ArrayList<String>();
                if (method.getReturnType() == SgClass.VOID) {
                    lines.add("ctrl." + method.getCallSignature() + ";");
                    lines.add("return null;");
                } else if (method.getReturnType().isPrimitive()) {
                    SgClass nonPrimitiveClass = SgClass.getNonPrimitiveClass((SgClassPool)ControllerQueueFactoryListener.this.pool, (SgClass)method.getReturnType());
                    lines.add("return " + nonPrimitiveClass.getName() + ".valueOf(ctrl." + method.getCallSignature() + ");");
                } else {
                    lines.add("return ctrl." + method.getCallSignature() + ";");
                }
                return lines;
            }
        }, new Class[]{Callable.class});
        this.generator.createClass(callableClass);
        return callableClass;
    }
}

