/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4swing;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import org.fuin.apps4j.Controller;
import org.fuin.apps4j.ModulImplIntfRef;
import org.fuin.apps4j.ModuleImplIntf;
import org.fuin.apps4j.View;
import org.fuin.apps4swing.AbstractControllerQueue;
import org.fuin.apps4swing.AbstractToControllerDispatcher;
import org.fuin.apps4swing.AbstractToViewDispatcher;
import org.fuin.apps4swing.ControllerTaskExecutor;
import org.fuin.apps4swing.ToControllerDispatcherFactoryListener;
import org.fuin.apps4swing.ToViewDispatcherFactoryListener;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.factory.ImplementationFactory;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;
import org.fuin.utils4j.Utils4J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControllerViewConnector<CTRL extends Controller<VIEW>, VIEW extends View<CTRL>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractControllerViewConnector.class);
    private final ByteCodeGenerator generator;
    private final SgClassPool pool;
    private final ImplementationFactory factory;
    private final ExecutorService executorService;
    private final String name;
    private final String ctrlPkg;
    private final Class<?> ctrlIntf;
    private final CTRL ctrlImpl;
    private final String viewPkg;
    private final Class<?> viewIntf;
    private final VIEW viewImpl;
    private final Class<?> moduleIntf;
    private final Class<? extends ModuleImplIntf> moduleImplIntf;
    private final int queueCapacity;
    private VIEW toViewDispatcher;
    private CTRL controllerQueue;
    private CTRL toControllerDispatcher;

    public AbstractControllerViewConnector(String name, String ctrlPkg, Class<?> ctrlIntf, CTRL ctrlImpl, String viewPkg, Class<?> viewIntf, VIEW viewImpl, Class<?> moduleIntf, ExecutorService executorService, int queueCapacity) {
        Utils4J.checkNotNull((String)"name", (Object)name);
        Utils4J.checkNotEmpty((String)"name", (String)name);
        this.name = name;
        Utils4J.checkNotNull((String)"ctrlPkg", (Object)ctrlPkg);
        this.ctrlPkg = ctrlPkg;
        Utils4J.checkNotNull((String)"ctrlIntf", ctrlIntf);
        this.ctrlIntf = ctrlIntf;
        Utils4J.checkNotNull((String)"ctrlImpl", ctrlImpl);
        this.ctrlImpl = ctrlImpl;
        Utils4J.checkNotNull((String)"viewPkg", (Object)viewPkg);
        this.viewPkg = viewPkg;
        Utils4J.checkNotNull((String)"viewIntf", viewIntf);
        this.viewIntf = viewIntf;
        Utils4J.checkNotNull((String)"viewImpl", viewImpl);
        this.viewImpl = viewImpl;
        this.moduleIntf = moduleIntf;
        if (moduleIntf == null) {
            this.moduleImplIntf = null;
        } else {
            ModulImplIntfRef ref = moduleIntf.getAnnotation(ModulImplIntfRef.class);
            if (ref == null) {
                throw new IllegalArgumentException("The interface '" + moduleIntf.getName() + "' ist not annotated with '" + ModulImplIntfRef.class.getName() + "'!");
            }
            this.moduleImplIntf = ref.value();
        }
        Utils4J.checkNotNull((String)"executorService", (Object)executorService);
        this.executorService = executorService;
        this.queueCapacity = queueCapacity;
        this.generator = new ByteCodeGenerator();
        this.pool = new SgClassPool();
        this.factory = new ImplementationFactory(this.pool);
        this.toViewDispatcher = this.createToViewDispatcher();
        this.controllerQueue = this.createControllerQueue(this.toViewDispatcher);
        this.toControllerDispatcher = this.createToControllerDispatcher(this.controllerQueue);
        ctrlImpl.setView(this.toViewDispatcher);
        viewImpl.setController(this.toControllerDispatcher);
    }

    private VIEW createToViewDispatcher() {
        View toViewDisp;
        SgClass toViewDispClass = SgClass.create((SgClassPool)this.pool, AbstractToViewDispatcher.class);
        ToViewDispatcherFactoryListener listener = new ToViewDispatcherFactoryListener(this.pool, this.generator);
        SgClass toViewDispClasz = this.factory.create(this.viewPkg, this.name + "ToViewDispatcher", toViewDispClass, null, (ImplementationFactoryListener)listener, new Class[]{this.viewIntf});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created ToViewDispatcher\n" + toViewDispClasz);
        }
        try {
            toViewDisp = (View)this.generator.createInstance(toViewDispClasz);
        }
        catch (Throwable throwable) {
            String msg = "Error creating ToViewDispatcher";
            LOG.error("Error creating ToViewDispatcher:\n" + toViewDispClasz);
            throw new RuntimeException("Error creating ToViewDispatcher", throwable);
        }
        AbstractToViewDispatcher impl = (AbstractToViewDispatcher)toViewDisp;
        impl.setView(this.viewImpl);
        return (VIEW)toViewDisp;
    }

    private CTRL createToControllerDispatcher(CTRL ctrlQueue) {
        Controller toCtrlDisp;
        SgClass toCtrlDispClass = SgClass.create((SgClassPool)this.pool, AbstractToControllerDispatcher.class);
        ToControllerDispatcherFactoryListener listener = new ToControllerDispatcherFactoryListener(this.pool, this.generator);
        SgClass toCtrlDispClasz = this.factory.create(this.ctrlPkg, this.name + "ToControllerDispatcher", toCtrlDispClass, null, (ImplementationFactoryListener)listener, new Class[]{this.ctrlIntf});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created ToControllerDispatcher\n" + toCtrlDispClasz);
        }
        try {
            toCtrlDisp = (Controller)this.generator.createInstance(toCtrlDispClasz);
        }
        catch (Throwable throwable) {
            String msg = "Error creating ToControllerDispatcher";
            LOG.error("Error creating ToControllerDispatcher:\n" + toCtrlDispClasz);
            throw new RuntimeException("Error creating ToControllerDispatcher", throwable);
        }
        AbstractToControllerDispatcher impl = (AbstractToControllerDispatcher)toCtrlDisp;
        impl.setController(ctrlQueue);
        impl.setExecutorService(this.executorService);
        return (CTRL)toCtrlDisp;
    }

    private CTRL createControllerQueue(VIEW toViewDispatcher) {
        Controller ctrlTaskDispImpl;
        SgClass ctrlQueueClasz = this.createControllerQueueClass();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created ControllerQueue\n" + ctrlQueueClasz);
        }
        try {
            ctrlTaskDispImpl = (Controller)this.generator.createInstance(ctrlQueueClasz);
        }
        catch (Throwable throwable) {
            String msg = "Error creating ControllerQueue";
            LOG.error("Error creating ControllerQueue:\n" + ctrlQueueClasz);
            throw new RuntimeException("Error creating ControllerQueue", throwable);
        }
        AbstractControllerQueue impl = (AbstractControllerQueue)ctrlTaskDispImpl;
        impl.setController(this.ctrlImpl);
        ControllerTaskExecutor ctrlTaskExecutor = new ControllerTaskExecutor();
        ctrlTaskExecutor.setEvents(new ArrayBlockingQueue<Runnable>(this.queueCapacity));
        ctrlTaskExecutor.setExecutorService(this.executorService);
        ctrlTaskExecutor.setView(toViewDispatcher);
        impl.setControllerTaskExecutor(ctrlTaskExecutor);
        return (CTRL)ctrlTaskDispImpl;
    }

    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected final SgClassPool getPool() {
        return this.pool;
    }

    protected final ByteCodeGenerator getGenerator() {
        return this.generator;
    }

    protected final ImplementationFactory getFactory() {
        return this.factory;
    }

    public final String getName() {
        return this.name;
    }

    public final String getCtrlPkg() {
        return this.ctrlPkg;
    }

    protected final Class<?> getCtrlIntf() {
        return this.ctrlIntf;
    }

    protected final CTRL getCtrlImpl() {
        return this.ctrlImpl;
    }

    protected final String getViewPkg() {
        return this.viewPkg;
    }

    protected final Class<?> getViewIntf() {
        return this.viewIntf;
    }

    protected final VIEW getViewImpl() {
        return this.viewImpl;
    }

    protected final Class<?> getModuleIntf() {
        return this.moduleIntf;
    }

    protected final Class<? extends ModuleImplIntf> getModuleImplIntf() {
        return this.moduleImplIntf;
    }

    protected final int getQueueCapacity() {
        return this.queueCapacity;
    }

    public final VIEW getToViewDispatcher() {
        return this.toViewDispatcher;
    }

    public final CTRL getToControllerDispatcher() {
        return this.toControllerDispatcher;
    }

    public final CTRL getControllerQueue() {
        return this.controllerQueue;
    }

    protected abstract SgClass createControllerQueueClass();
}

