/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4swing;

import java.util.ArrayList;
import java.util.List;

import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;

/**
 * Creates the method bodies for a {@link AbstractModuleImplIntfListener}
 * implementation.
 */
public final class ModuleImplIntfListenerFactoryListener implements ImplementationFactoryListener {

    /**
     * {@inheritDoc}
     */
    public final void afterClassCreated(final SgClass clasz) {
        // Do nothing
    }

    /**
     * {@inheritDoc}
     */
    public final List<String> createBody(final SgMethod method, final Class<?>... intf) {

        final SgClass clasz = method.getOwner();

        // Get the -one and only- argument of the method
        if (method.getArguments().size() != 1) {
            throw new IllegalArgumentException("The method '" + method.getSignature()
                    + "' of type '" + clasz.getName() + "' has not exactly one argument!");
        }
        final String argName = method.getArguments().get(0).getName();
        final SgClass argType = method.getArguments().get(0).getType();
        final String varName = method.getName() + argType.getSimpleName();

        // Add a variable with the same type as the argument
        final SgField field = new SgField(clasz, "private volatile", argType, varName, "");
        clasz.addField(field);

        // Add a getter method with the same return type as argument
        final SgMethod getter = new SgMethod(clasz, "public", argType, "get"
                + SgUtils.firstCharUpper(varName));
        getter.addBodyLine("return " + varName + ";");
        clasz.addMethod(getter);

        // Create the body
        final List<String> lines = new ArrayList<String>();
        lines.add(varName + "=" + argName + ";");
        lines.add("finished();");
        return lines;

    }

}
