/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4swing;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.WindowConstants;

import org.fuin.apps4j.Module;
import org.fuin.utils4j.Utils4J;

/**
 * A frame containing a module UI.
 */
public final class ModuleFrame {

    private final JFrame frame;

    /**
     * Constructor with module.
     * 
     * @param module
     *            Module.
     */
    public ModuleFrame(final Module module) {
        super();

        Utils4J.checkNotNull("module", module);

        final Object ui = module.getModuleUI();
        if (ui == null) {
            throw new IllegalArgumentException("The module UI is null!");
        }
        if (!(ui instanceof Container)) {
            throw new IllegalArgumentException("The module UI is of type '" + ui.getClass()
                    + "' and not as expected of type '" + Container.class.getName() + "'!");
        }

        final Container cont = (Container) ui;

        frame = new JFrame(module.getModuleTitle());
        frame.setContentPane(cont);
        frame.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
        frame.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(final WindowEvent e) {
                module.cancel();
            }
        });
        frame.setSize(cont.getPreferredSize());

    }

    /**
     * Make the module's UI visible.
     */
    public final void show() {

        // TODO positioner.position(frame);

        final Insets insets = frame.getInsets();

        frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top
                + insets.bottom);

        frame.setVisible(true);

        // TODO frame.setResizable(resizeable);

        // TODO frame.getRootPane().setDefaultButton(view.getDefaultButton());

    }

}
