/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4swing;

/**
 * Helper class to transport a result in a thread safe way. Be aware that only
 * the access to the object's reference is synchronized (not to the content).
 * 
 * @param <RESULT>
 *            Type of the result.
 */
public class EDTResult<RESULT> {

	private RESULT resultValue = null;

	/**
	 * Returns the value.
	 * 
	 * @return Value.
	 */
	public final synchronized RESULT getResultValue() {
		return resultValue;
	}

	/**
	 * Sets the value.
	 * 
	 * @param resultValue
	 *            Value to set.
	 */
	public final synchronized void setResultValue(final RESULT resultValue) {
		this.resultValue = resultValue;
	}

}
