/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4swing;

import java.util.concurrent.ExecutorService;

import org.fuin.apps4j.Controller;
import org.fuin.apps4j.View;
import org.fuin.srcgen4javassist.SgClass;

/**
 * Connects a controller and it's view.
 * 
 * @param <CTRL>
 *            Type of controller.
 * @param <VIEW>
 *            Type of view.
 */
public final class ControllerViewConnector<CTRL extends Controller<VIEW>, VIEW extends View<CTRL>>
        extends AbstractControllerViewConnector<CTRL, VIEW> {

    /**
     * Constructor with all possible values.
     * 
     * @param name
     *            Basic name that is shared by controller and view. Used as
     *            prefix for the generated classes - Cannot be <code>null</code>
     *            or empty.
     * @param ctrlPkg
     *            Package of the generated controller classes - Cannot be
     *            <code>null</code>.
     * @param ctrlIntf
     *            Controller interface to generate an implementation for -
     *            Cannot be <code>null</code>.
     * @param ctrlImpl
     *            The "real" controller implementation - Cannot be
     *            <code>null</code>.
     * @param viewPkg
     *            Package of the generated view classes - Cannot be
     *            <code>null</code>.
     * @param viewIntf
     *            View interface to generate an implementation for - Cannot be
     *            <code>null</code>.
     * @param viewImpl
     *            The "real" view implementation - Cannot be <code>null</code>.
     * @param executorService
     *            Executor service to use - Cannot be <code>null</code>.
     * @param queueCapacity
     *            Capacity of the {@link ArrayBlockingQueue}.
     */
    public ControllerViewConnector(final String name, final String ctrlPkg,
            final Class<?> ctrlIntf, final CTRL ctrlImpl, final String viewPkg,
            final Class<?> viewIntf, final VIEW viewImpl, final ExecutorService executorService,
            final int queueCapacity) {

        super(name, ctrlPkg, ctrlIntf, ctrlImpl, viewPkg, viewIntf, viewImpl, null,
                executorService, queueCapacity);

    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected final SgClass createControllerQueueClass() {
        final ControllerQueueFactoryListener listener = new ControllerQueueFactoryListener(
                getPool(), getGenerator());
        final SgClass parentClass = SgClass.create(getPool(), AbstractControllerQueue.class);
        return getFactory().create(getCtrlPkg(), getName() + "ControllerQueue", parentClass, null,
                listener, getCtrlIntf());
    }

}
