/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4swing;

/**
 * Dispatch events from the controller to the view.
 * 
 * @param <VIEW>
 *            Type of the view.
 */
public abstract class AbstractToViewDispatcher<VIEW> {

	private VIEW view;

	/**
	 * Returns the view events are dispatched to.
	 * 
	 * @return View or <code>null</code>.
	 */
	public final VIEW getView() {
		return view;
	}

	/**
	 * Sets the view events are dispatched to.
	 * 
	 * @param view
	 *            View to set or <code>null</code>.
	 */
	public final void setView(final VIEW view) {
		this.view = view;
	}

}
