/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4swing;

import java.util.concurrent.ExecutorService;

import org.fuin.apps4j.Controller;

/**
 * Dispatch events from the view to the controller using a new thread.
 * 
 * @param <CTRL>
 *            Type of the controller.
 * @param <VIEW>
 *            Type of the view.
 */
public abstract class AbstractToControllerDispatcher<CTRL extends Controller<VIEW>, VIEW> {

	private ExecutorService executor;

	private CTRL controller;

	/**
	 * Default constructor.
	 */
	public AbstractToControllerDispatcher() {
		super();
	}

	/**
	 * Execute the runnable in the controller's thread.
	 * 
	 * @param runnable
	 *            Runnable to execute.
	 */
	protected final void execute(final Runnable runnable) {
		executor.execute(runnable);
	}

	/**
	 * Returns the controller the dispatcher works on.
	 * 
	 * @return Controller.
	 */
	public final CTRL getController() {
		return controller;
	}

	/**
	 * Sets the controller the dispatcher works on.
	 * 
	 * @param controller
	 *            Controller.
	 */
	public final void setController(final CTRL controller) {
		this.controller = controller;
	}

	/**
	 * Sets the executor service.
	 * 
	 * @param executor
	 *            Executor to set.
	 */
	public final void setExecutorService(final ExecutorService executor) {
		this.executor = executor;
	}

}
