/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4swing;

import org.fuin.apps4j.ModuleImplIntfListener;

/**
 * Basic functionality common for all module interface listener implementations.
 */
public abstract class AbstractModuleImplIntfListener implements ModuleImplIntfListener {

    private volatile boolean finished = false;

    /**
     * Returns if the result values are set.
     * 
     * @return If the results are available <code>true</code> else
     *         <code>false</code>.
     */
    public final boolean isFinished() {
        return finished;
    }

    /**
     * Marks the result values as set. This should be the last command in a
     * method.
     */
    protected final void finished() {
        this.finished = true;
    }

}
