/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4swing;

import org.fuin.apps4j.Module;
import org.fuin.apps4j.ModuleImplIntf;
import org.fuin.utils4j.Utils4J;

/**
 * Basic functionality common for all module implementations.
 */
public abstract class AbstractModuleImpl implements Module {

    private ModuleImplIntf module;

    /**
     * Waits until the listener has received results.
     * 
     * @param listener
     *            Listener to wait for.
     */
    public final void waitForResults(final AbstractModuleImplIntfListener listener) {
        Utils4J.checkNotNull("listener", listener);
        while (!listener.isFinished()) {
            try {
                Thread.sleep(50);
            } catch (final InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /**
     * Returns the real implementation used.
     * 
     * @return Actual implementation doing the work.
     */
    public final ModuleImplIntf getModule() {
        return module;
    }

    /**
     * Sets the real implementation used.
     * 
     * @param module
     *            Actual implementation doing the work.
     */
    public final void setModule(final ModuleImplIntf module) {
        this.module = module;
    }

}
