/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4j.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import org.fuin.apps4j.base.Target;
import org.fuin.apps4j.base.TargetImpl;
import org.fuin.apps4j.menu.DividerMenuItem;
import org.fuin.apps4j.menu.MenuItem;
import org.fuin.apps4j.menu.TextMenuItem;

@XmlRootElement(name="item")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class TextMenuItemImpl
implements TextMenuItem {
    @XmlAttribute
    private final String text;
    @XmlAttribute(name="mnemonic-index")
    private final Integer mnemonicIndex;
    @XmlAttribute
    private final String accelerator;
    @XmlElement(type=TargetImpl.class)
    private final Target target;
    @XmlElementRefs(value={@XmlElementRef(type=TextMenuItemImpl.class), @XmlElementRef(type=DividerMenuItem.class)})
    private final List<MenuItem> items;

    TextMenuItemImpl() {
        this.text = null;
        this.mnemonicIndex = null;
        this.accelerator = null;
        this.target = null;
        this.items = null;
    }

    public TextMenuItemImpl(String text) {
        this(text, null, null, null, new MenuItem[0]);
    }

    public TextMenuItemImpl(String text, Integer mnemonicIndex) {
        this(text, null, mnemonicIndex, null, new MenuItem[0]);
    }

    public TextMenuItemImpl(String text, String accelerator, Integer mnemonicIndex) {
        this(text, accelerator, mnemonicIndex, null, new MenuItem[0]);
    }

    public TextMenuItemImpl(String text, String accelerator) {
        this(text, accelerator, null, null, new MenuItem[0]);
    }

    public TextMenuItemImpl(String text, String accelerator, Integer mnemonicIndex, Target target, MenuItem ... items) {
        this(text, accelerator, mnemonicIndex, target, items == null || items.length == 0 ? null : Arrays.asList(items));
    }

    public TextMenuItemImpl(String text, String accelerator, Integer mnemonicIndex, Target target, List<MenuItem> items) {
        this.text = text;
        this.accelerator = accelerator;
        this.mnemonicIndex = mnemonicIndex;
        this.target = target;
        if (items == null) {
            this.items = null;
        } else {
            this.items = new ArrayList<MenuItem>(items.size());
            this.items.addAll(items);
        }
    }

    @Override
    public final String getAccelerator() {
        return this.accelerator;
    }

    @Override
    public final Integer getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    @Override
    public final String getText() {
        return this.text;
    }

    @Override
    public final List<MenuItem> getItems() {
        if (this.items == null) {
            return null;
        }
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public final Target getTarget() {
        return this.target;
    }

    public final String toString() {
        return this.text;
    }
}

