/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.apps4j.menu;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import org.fuin.apps4j.base.TargetImpl;
import org.fuin.apps4j.menu.DividerMenuItem;
import org.fuin.apps4j.menu.MarshalMenuException;
import org.fuin.apps4j.menu.Menu;
import org.fuin.apps4j.menu.MenuItem;
import org.fuin.apps4j.menu.TextMenuItemImpl;
import org.fuin.apps4j.menu.UnmarshalMenuException;

@XmlRootElement(name="menu")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class MenuImpl
implements Menu {
    @XmlAttribute(required=true)
    private final String id;
    @XmlElementRefs(value={@XmlElementRef(type=TextMenuItemImpl.class), @XmlElementRef(type=DividerMenuItem.class)})
    private final List<MenuItem> items;

    MenuImpl() {
        this.id = null;
        this.items = null;
    }

    public MenuImpl(String id, MenuItem ... items) {
        this(id, items == null || items.length == 0 ? null : Arrays.asList(items));
    }

    public MenuImpl(String id, List<MenuItem> items) {
        if (id == null) {
            throw new IllegalArgumentException("The argument 'id' cannot be null!");
        }
        this.id = id;
        if (items == null) {
            this.items = null;
        } else {
            this.items = new ArrayList<MenuItem>(items.size());
            this.items.addAll(items);
        }
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final List<MenuItem> getItems() {
        if (this.items == null) {
            return null;
        }
        return Collections.unmodifiableList(this.items);
    }

    public static MenuImpl createFromXml(String xml) throws UnmarshalMenuException {
        return MenuImpl.createFromXml(new StringReader(xml));
    }

    public static MenuImpl createFromXml(Reader reader) throws UnmarshalMenuException {
        try {
            JAXBContext jaxbContext = MenuImpl.createJaxbContext();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (MenuImpl)unmarshaller.unmarshal(reader);
        }
        catch (JAXBException ex) {
            throw new UnmarshalMenuException(ex);
        }
    }

    public String writeToXml() throws MarshalMenuException {
        return MenuImpl.writeToXml(this);
    }

    public void writeToXml(Writer writer) throws MarshalMenuException {
        MenuImpl.writeToXml(this, writer);
    }

    private static String writeToXml(MenuImpl menu) throws MarshalMenuException {
        StringWriter writer = new StringWriter();
        MenuImpl.writeToXml(menu, writer);
        return writer.toString();
    }

    private static void writeToXml(MenuImpl menu, Writer writer) throws MarshalMenuException {
        try {
            JAXBContext jaxbContext = MenuImpl.createJaxbContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)menu, writer);
        }
        catch (JAXBException ex) {
            throw new MarshalMenuException(ex);
        }
    }

    private static JAXBContext createJaxbContext() throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MenuImpl.class, TextMenuItemImpl.class, TargetImpl.class, DividerMenuItem.class});
        return jaxbContext;
    }
}

