/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4j.menu;

import java.util.List;

import org.fuin.apps4j.base.Target;

/**
 * Defines a text menu item.
 */
public interface TextMenuItem extends MenuItem {

    /**
     * Returns the target that is attached to the menu item. If the item has sub
     * menu items this value is ignored.
     * 
     * @return Target or <code>null</code>.
     */
    public Target getTarget();

    /**
     * Returns a list of sub menu items.
     * 
     * @return Unmodifiable list or <code>null</code>
     */
    public List<MenuItem> getItems();

    /**
     * Returns the text.
     * 
     * @return Text.
     */
    public String getText();

    /**
     * Returns the index of the character that defines the mnemonic.
     * 
     * @return Index.
     */
    public Integer getMnemonicIndex();

    /**
     * Returns the textual description of the keyboard accelerator.
     * 
     * @return Accelerator.
     */
    public String getAccelerator();

}
