/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4j.base;

import java.lang.annotation.RetentionPolicy;

/**
 * Qualifies the concrete usage of an MVC object to be injected.
 */
@java.lang.annotation.Documented
@java.lang.annotation.Retention(RetentionPolicy.RUNTIME)
@javax.inject.Qualifier
public @interface Usage {

    /** Type of usage. */
    Type value();

    /**
     * Usage types.
     */
    public enum Type {

        /** Used in a controller. */
        Controller,

        /** Used in a view. */
        View,

        /** Used by a third party (outside the MVC classes). */
        ThirdParty,

        /** Used internally. */
        Intern

    }

}
