/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4j.base;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * Default implementation of the target.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "target")
public final class TargetImpl implements Target {

    @XmlAttribute
    private final String id;

    @XmlAttribute(name = "module-interface")
    private final String moduleInterface;

    @XmlAttribute(name = "module-impl")
    private final String moduleImpl;

    /**
     * Default constructor for JAXB.
     */
    TargetImpl() {
        id = null;
        moduleInterface = null;
        moduleImpl = null;
    }

    /**
     * Constructor with all data.
     * 
     * @param id
     *            Target id.
     * @param moduleInterface
     *            Full qualified name of the interface.
     * @param moduleImpl
     *            Full qualified name of the implementation class.
     */
    public TargetImpl(final String id, final String moduleInterface, final String moduleImpl) {
        super();
        this.id = id;
        this.moduleInterface = moduleInterface;
        this.moduleImpl = moduleImpl;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getModuleInterface() {
        return moduleInterface;
    }

    @Override
    public String getModuleImpl() {
        return moduleImpl;
    }

    // CHECKSTYLE:OFF Generated code
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        return result;
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final TargetImpl other = (TargetImpl) obj;
        if (id == null) {
            if (other.id != null) {
                return false;
            }
        } else if (!id.equals(other.id)) {
            return false;
        }
        return true;
    }
    // CHECKSTYLE:ON

}
