/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4j.base;

/**
 * This is the part of the controller used by the view. Contains all functions
 * the view needs to delegate to the controller.<br>
 * <br>
 * Methods may not have any return values (except {@link #getControllerUI()}).<br>
 * <br>
 * TODO Is above restriction correct? This is a Swing issue and may not be a
 * problem for other frameworks!)!
 * 
 * @param <VIEW>
 *            The controller the view interacts with.
 */
public interface Controller<VIEW> {

    /**
     * Returns the UI. This depends on the target framework (Swing...).
     * 
     * @return User interface depending on the implementation.
     */
    public Object getControllerUI();

}
