/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.apps4j.base;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Common utilities.
 */
public final class Apps4JUtils {

    private Apps4JUtils() {
        throw new UnsupportedOperationException("Cannot create instance of a utility class!");
    }

    /**
     * Creates an executor service with a cached thread pool and a shutdown hook
     * attached.
     * 
     * @return New executor service instance.
     */
    public static ExecutorService createExecutorService() {
        final ExecutorService executorService = Executors.newCachedThreadPool();
        Runtime.getRuntime().addShutdownHook(new Thread() {
            @Override
            public void run() {
                // shutdown thread pool
                executorService.shutdown();
            }
        });
        return executorService;
    }

}
