package org.axonframework.domain;

import java.util.UUID;

public final class AggregateIdFactoryUUID implements AggregateIdFactory {

	@Override
	public AggregateId create() {
		return new AggregateIdUUID(UUID.randomUUID());
	}

	@Override
	public AggregateId fromString(final String aggregateId) {
		return new AggregateIdUUID(UUID.fromString(aggregateId));
	}

}
