package org.axonframework.domain;

import java.util.UUID;

import org.axonframework.util.Assert;

public final class AggregateIdUUID<TYPE> implements AggregateId<TYPE>, Comparable<AggregateIdUUID<TYPE>> {

	private final UUID uuid;
	
	public AggregateIdUUID(final UUID uuid) {
		Assert.isTrue(uuid != null, "The uuid cannot be null");
		this.uuid = uuid;
	}

	@Override
	public String toString() {
		return uuid.toString();
	}

	@Override
	public int compareTo(final AggregateIdUUID<TYPE> theOther) {		
		return uuid.compareTo(theOther.uuid);
	}

	@Override
	public int hashCode() {
		return uuid.hashCode();
	}

	@Override
	public boolean equals(final Object other) {
	    if (this == other) return true; 
	    if (other == null) return false;  
	    if (this.getClass() != other.getClass()) return false; 
		final AggregateIdUUID<?> theOther = (AggregateIdUUID<?>)other;
		return uuid.equals(theOther.uuid);
	}
	
}
