package org.axonframework.domain;

import java.util.UUID;

public final class AggregateIdFactoryUUID implements AggregateIdFactory {

	@Override
	public <TYPE> AggregateId<TYPE> create(
			final Class<TYPE> aggregateType) {
		return new AggregateIdUUID<TYPE>(UUID.randomUUID());
	}

	@Override
	public <TYPE> AggregateId<TYPE> fromString(final Class<TYPE> aggregateType, final String aggregateIdString) {
		return new AggregateIdUUID<TYPE>(UUID.fromString(aggregateIdString));
	}

}
